# ApisecBolt

ApisecBolt is a Chrome extension for capturing and monitoring network traffic with a focus on API requests. It allows users to filter and record network activity for specific domains or APIs.

## Features

- **Network Traffic Monitoring**: Capture HTTP/HTTPS requests and responses from web applications
- **URL Filtering**: Focus on specific API endpoints by filtering based on base URL
- **Request Data Collection**: Capture URL, method, headers, request body, and response code
- **Data Export**: Download captured traffic data as JSON for analysis

## Installation

### From Source

1. Clone or download this repository
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable "Developer mode" by toggling the switch in the top right
4. Click "Load unpacked" and select the directory containing the extension files
5. The ApisecBolt icon should now appear in your browser toolbar

## Usage

1. Click on the ApisecBolt icon in your browser toolbar to open the popup
2. Enter the base URL you want to monitor (e.g., api.example.com)
3. Click "Start Capturing" to begin monitoring network traffic
4. Navigate to the web application you want to monitor
5. View the count of captured requests in the popup
6. Click "Download Data" to export the captured traffic as a JSON file
7. Click "Stop Capturing" when you're done to deactivate the extension

## Development

### Structure

```
├── assets/               # Images and icons
├── js/                   # JavaScript files
│   └── background.js     # Background script for network monitoring
├── popup/                # Popup UI files
│   ├── popup.html        # Popup HTML structure
│   ├── popup.css         # Popup styling
│   └── popup.js          # Popup logic
└── manifest.json         # Extension configuration
```

### Customization

To extend this extension:
1. Modify the URL validation in `popup.js` to fit your specific requirements
2. Add additional filtering options in `background.js`
3. Enhance the data capture functionality by adding more fields to the captured data

## Privacy

This extension:
- Only captures network traffic from domains you explicitly select
- Saves data locally and doesn't transmit your browsing data
- Does not send any analytics or usage data

## License

This project is licensed under the MIT License - see the LICENSE file for details. 